#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll key;
    int count;
} Entry;

int cmp(const void *a, const void *b) {
    ll ka = ((Entry*)a)->key;
    ll kb = ((Entry*)b)->key;
    if (ka < kb) return -1;
    if (ka > kb) return 1;
    return 0;
}

ll count_pairs(Entry *arr, int n) {
    qsort(arr, n, sizeof(Entry), cmp);
    ll total = 0;
    ll cnt = 1;
    for (int i = 1; i < n; i++) {
        if (arr[i].key == arr[i-1].key) cnt++;
        else {
            total += cnt * (cnt - 1);
            cnt = 1;
        }
    }
    total += cnt * (cnt - 1);
    return total;
}

int main() {
    int N;
    scanf("%d", &N);

    ll *x = malloc(N * sizeof(ll));
    ll *y = malloc(N * sizeof(ll));

    for (int i = 0; i < N; i++)
        scanf("%lld %lld", &x[i], &y[i]);

    Entry *d1 = malloc(N * sizeof(Entry));
    Entry *d2 = malloc(N * sizeof(Entry));

    for (int i = 0; i < N; i++) {
        d1[i].key = x[i] - y[i];
        d1[i].count = 1;
        d2[i].key = x[i] + y[i];
        d2[i].count = 1;
    }

    ll ans = 0;
    ans += count_pairs(d1, N);
    ans += count_pairs(d2, N);

    printf("%lld\n", ans);

    free(x);
    free(y);
    free(d1);
    free(d2);
    return 0;
}